<?php
/*
Plugin Name: SearchLink
Version: 0.42
Plugin URI: http://vince.tikasz.hu/searchlink/
Description: 
Author: Tikász Vince
Author URI: http://vince.tikasz.hu
*/

define( 'SEARCHLINK_DEBUG', false );


class Searchlink
{
	var $options;

	/**
	 * Display debug messages?
	 * @var Bool $debug
	 */
	var $debug;

	/**
	 * Debug messages
	 * @var String $debug_msg
	 */
	var $debug_msg;

	/**
	 * Engines
	 * @var Array
	 * @private
	 */
	var $engines;

	/**
	 * Protocolls
	 * @var Array
	 * @private
	 */
	var $protocolls;

	/**
	 * Alliases
	 * @var Array
	 * @private
	 */
	var $aliases;
	
	/**
	 * Cunstructor
	 *
	 * @return void
	 */
	function Searchlink()
	{
		$this->debug = SEARCHLINK_DEBUG;
		$this->options = get_option('searchlink_options');
		

		if ( true == $this->options['engine']['sitesearch'] )
		{
			$this->addEngine( 'site', '/?s=', array('itt', 'here')  );
		}

		if ( true == $this->options['engine']['google'] )
		{
			$this->addEngine( 'google', 'http://www.google.com/search?q=' );
		}
		if ( true == $this->options['engine']['google-image'] )
		{
			$this->addEngine( 'google-image', 'http://images.google.com/images?q=', array( 'google-images', 'google-picture', 'google-pictures' ), true, 'google' );
		}

		if ( true == $this->options['engine']['yahoo'] )
		{
			$this->addEngine( 'yahoo', 'http://search.yahoo.com/search?p=' );
		}
		if ( true == $this->options['engine']['yahoo-image'] )
		{
			$this->addEngine( 'yahoo-image', 'http://images.search.yahoo.com/search/images?p=', array( 'yahoo-images', 'yahoo-picture', 'yahoo-pictures' ), true, 'yahoo' );
		}

		if ( true == $this->options['engine']['msn'] )
		{
			$this->addEngine( 'msn', 'http://search.live.com/results.aspx?q=', 'live' );
		}
		if ( true == $this->options['engine']['msn-image'] )
		{
			$this->addEngine( 'msn-image', 'http://search.live.com/images/results.aspx?q=', array( 'live-image', 'msn-image', 'msn-images', 'live-picture', 'msn-picture', 'live-pictures', 'msn-pictures' ), true, 'msn' );
		}

		if ( true == $this->options['engine']['altavista'] )
		{
			$this->addEngine( 'altavista', 'http://www.altavista.com/web/results?q=' );
		}
		if ( true == $this->options['engine']['altavista-image'] )
		{
			$this->addEngine( 'altavista-image', 'http://www.altavista.com/image/results?q=', array( 'altavista-images', 'altavista-picture', 'altavista-pictures' ), true, 'altavista' );
		}

		if ( true == $this->options['engine']['alltheweb'] )
		{
			$this->addEngine( 'alltheweb', 'http://www.alltheweb.com/search?q=' );
		}
		if ( true == $this->options['engine']['alltheweb-image'] )
		{
			$this->addEngine( 'alltheweb-image', 'http://www.alltheweb.com/search?cat=img&amp;q=', array( 'alltheweb-images', 'alltheweb-picture', 'alltheweb-pictures' ), true, 'alltheweb' );
		}
		if ( true == $this->options['engine']['miner'] )
		{
			$this->addEngine( 'miner', 'http://miner.hu/?q=' );
		}
		if ( true == $this->options['engine']['tango'] )
		{
			$this->addEngine( 'tango', 'http://www.tango.hu/search.php?q=' );
		}
		if ( true == $this->options['engine']['tango-image'] )
		{
			$this->addEngine( 'tango-image', 'http://www.tango.hu/pic.php?q=', array( 'tango-images', 'tango-picture', 'tango-pictures' ), true, 'tango' );
		}
	}
	
	/**
	 * Default Options for reset optoions and for reset
	 *
	 * @return Array
	 */
	function getDefaultOptions()
	{
		return array(
			'engine' => array(
				'sitesearch' => true, 
				'google' => true, 
				'google-image' => true, 
				'yahoo' => true, 
				'yahoo-image' => true, 
				'msn' => true, 
				'msn-image' => true, 
				'altavista' => true, 
				'altavista-image' => true, 
				'alltheweb' => true, 
				'alltheweb-image' => true, 
				'miner' => true, 
				'tango' => false, 
				'tango-image' => false, 
			)
		);
	}


	/**
	 * Register Activation
	 *
	 * @return void
	 */
	function register_activation()
	{
		$options = $this->getDefaultOptions();
		add_option('searchlink_options', $options);
		$searchlink_options = get_option('searchlink_options');
		foreach ( $options as $key => $val )
		{
			if (!isset($searchlink_options[$key]))
			{
				$searchlink_options[$key] = $options[$key];
			}
		}
		update_option('searchlink_options', $searchlink_options);
	}

	/**
	 * Add an engine
	 *
	 * @param String $name
	 * @param String $engine_url
	 * @param Array $aliases
	 * @param Bool $image
	 * @return void
	 */
	function addEngine( $name, $engine_url, $aliases = array(), $image = false, $extra_class = '' )
	{
		$this->engines[ $name ] = array(
			'engine_url' => $engine_url,
			'aliases' => $aliases,
			'image' => $image,
			'extra-class' => $extra_class
		);
		$this->protocolls[ $engine_url ] = array( $name );
		$this->aliases[ $name ] = $name;
		foreach( (array)$aliases as $alias )
		{
			$this->protocolls[ $engine_url ][] = $alias;
			$this->aliases[ $alias ] = $name;
		}
	}

	/**
	 * Replace Callback to apply filter on content
	 *
	 * @param Array $matches
	 * @return String
	 */
	function replace_callback( $matches )
	{
		//global $Searchlink;
		$engine_name = $this->aliases[ $matches[2] ];
		$engine = $this->engines[ $engine_name ];

		$class = array( 'search', $engine_name );
		if ( isset( $engine['image'] ) && true == $engine['image'] )
		{
			$class[] = 'search-image';
		}
		if ( !empty(  $engine['extra-class'] ) )
		{
			$class[] = trim( $engine['extra-class'] );
		}
		
		if ( true == $this->debug )
		{
			$this->debug_msg .= "\nmatches : ".print_r( $matches, 1 );
			$this->debug_msg .= "\nengine_name : ".print_r( $engine_name, 1 );
			$this->debug_msg .= "\nengine : ".print_r( $engine, 1 );
			$this->debug_msg .= "\nclasss : " .print_r( $class, 1 );
			$this->debug_msg .= "\n---------\n";
		}
		return '<a rel="search" class="'.join( ' ', $class ).'" href="' .$engine['engine_url'] .$matches[3].'">'.$matches[1].'</a>';
	}
	
	/**
	 * Search Link Parser
	 *
	 * convert 'google://search+me+formated anchors to HTML anchors
	 * 
	 * @param String $text
	 * @return String
	 */
	function the_content( $text )
	{
		$ret = $text;
		foreach( $this->protocolls as $engine => $protocolls )
		{
			$regex = "/\b(?<!')((".join('|', $protocolls )."):\/\/([^<'\s]*))\b/i";
			
			if ( preg_match( $regex, $ret ) )
			{
				if ( $this->debug == true )
				{
					$this->debug_msg .= "\n- - -\n{$regex}\n";
				}
				$ret = preg_replace_callback(
					$regex,
					array( $this, 'replace_callback' ),
					$ret
				);
			}
		}
		
		if ( $this->debug == true )
		{
			$ret = '<pre>'. htmlentities( print_r( $this ) ).'</pre>'.$ret;
		}
		
		return $ret;
	}


/**************************************************
 * Administrator FUNCTIONS
 *************************************************/

	/**
	 * Register admin menu item
	 * @return void
	 */
	function admin_menu()
	{
		if (version_compare($wp_version, '2.6', '<')) // Using old WordPress
		{
            load_plugin_textdomain('searchlink', 'wp-content/plugins/searchlink/languages');
		}
        else
        {
            load_plugin_textdomain('searchlink', 'wp-content/plugins/searchlink/languages', 'searchlink/languages');
		}
		add_options_page(
			__('Searchlink Options', 'searchlink'),
			__('Searchlink', 'searchlink'),
			5,
			basename(__FILE__),
			array( $this, 'options_page' )
		);
	}
		
	
	/**
	 * Options page
	 * 
	 * @return void
	 */
	function options_page()
	{
		if ( ! $this->options )
		{
			$this->register_activation();
		}
		$update = false;
		if ( isset( $_POST['searchlink_update'] ) && 'update' == $_POST['searchlink_update'] )
		{
			foreach( $this->options['engine'] as $engine => $enabled )
			{
				
				$this->options['engine'][ $engine ] = (
					isset( $_POST['serarchlink']['engine'][ $engine ] )
					&& $_POST['serarchlink']['engine'][ $engine ] == 1
				);
			}
			update_option('searchlink_options', $this->options );
			$update = true;
			echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p><strong>' . __('Options saved.') . '</strong></p></div>';
		}
		
		if ( true == $this->debug )
		{
			echo '<pre>'. var_export( $this->options, 1 ) . '</pre>';
			echo '<pre>'. var_export( $_POST, 1 ) . '</pre>';

		}

		echo '
<div class="wrap">
	<h2>' . __('Searchlink Options', 'searchlink') . '</h2>
	<form name="form1" method="post" action="' . $_SERVER['REQUEST_URI'] . '">
			<input type="hidden" name="searchlink_update" value="update" />
			<table class="form-table">
				<tr valign="top">
					<th scope="row">'.__('Enabled search engines', 'searchlink').'</th>
			        <td><fieldset>
			        	<legend class="hidden">'.__('Enabled search engines').'</legend>

   						<label for="searchlink_site">' . __('Site', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][sitesearch]" id="searchlink_site" value="1" ' . ( true == $this->options['engine']['sitesearch'] ? ' checked="checked"' : '' ) . ' />
						<br/>


						<label for="searchlink_google">' .  __('Google', 'searchlink' ) . '</label>
						<input type="checkbox" name="serarchlink[engine][google]" id="searchlink_google" value="1" ' . ( true == $this->options['engine']['google'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_google-image">' .  __('Google Image', 'searchlink' ) . '</label>
						<input type="checkbox" name="serarchlink[engine][google-image]" id="searchlink_site" value="1" ' . ( true == $this->options['engine']['google-image'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_yahoo">' . __('Yahoo', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][yahoo]" id="searchlink_yahoo" value="1" ' . ( true == $this->options['engine']['yahoo'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_yahoo-image">' . __('Yahoo Image', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][yahoo-image]" id="searchlink_yahoo-image" value="1" ' . ( true == $this->options['engine']['yahoo-image'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_msn">' . __('Live Search', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][msn]" id="searchlink_msn" value="1" ' . ( true == $this->options['engine']['msn'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_msn-image">' . __('Live Image Search', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][msn-image]" id="searchlink_msn-image" value="1" ' . ( true == $this->options['engine']['msn-image'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_altavista">' . __('Altavista', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][altavista]" id="searchlink_altavista" value="1" ' . ( true == $this->options['engine']['altavista'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_altavista-image">' . __('Altavista Image', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][altavista-image]" id="searchlink_altavista-image" value="1" ' . ( true == $this->options['engine']['altavista-image'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_alltheweb">' . __('AllTheWeb', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][alltheweb]" id="searchlink_alltheweb" value="1" ' . ( true == $this->options['engine']['alltheweb'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_alltheweb-image">' . __('AllTheWeb Image', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][alltheweb-image]" id="searchlink_alltheweb-image" value="1" ' . ( true == $this->options['engine']['alltheweb-image'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_miner">' . __('Miner', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][miner]" id="searchlink_miner" value="1" ' . ( true == $this->options['engine']['miner'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_tango">' . __('Tango', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][tango]" id="searchlink_tango" value="1" ' . ( true == $this->options['engine']['tango'] ? ' checked="checked"' : '' ) . ' />
						<br/>

						<label for="searchlink_tango-image">' . __('Tango Image', 'searchlink') . '</label>
						<input type="checkbox" name="serarchlink[engine][tango-image]" id="searchlink_tango-image" value="1" ' . ( true == $this->options['engine']['tango-image'] ? ' checked="checked"' : '' ) . ' />
						<br/>

			        </fieldset></td>
			    </tr>
			</table>
		<p class="submit">
		<input class="button-primary" type="submit" value="' . __('Save Changes &raquo;', 'searchlink') . '" name="Submit" >
		</p>
	</form>
</div>
';
	}
	
}
/**
 * Get Searchlink instance
 */
function getSearchlink()
{
	static $Searchlink;
	if ( is_null( $Searchlink ) )
	{
		$Searchlink = new Searchlink();
	}
	return $Searchlink;
}


// Hooks
register_activation_hook(__FILE__, array('WPGeo', 'register_activation'));

// Frontend Hooks
$Searchlink = getSearchlink();
add_filter('the_content', array( $Searchlink, 'the_content' ) );
add_filter('the_excerpt', array( $Searchlink, 'the_content' ) );
add_filter('comment_text', array( $Searchlink, 'the_content' ) );

// Admin Hooks
add_action('admin_menu', array( $Searchlink, 'admin_menu' ) );

?>
