<?php
/*
Plugin Name: SearchLink
Version: 0.2
Plugin URI: http://vince.tikasz.hu/searchlink/
Description: 
Author: Tikász Vince
Author URI: http://vince.tikasz.hu
*/

/**
 * Search Link Parser
 *
 * convert 'google://search+me+formated anchors to HTML anchors
 * 
 * @param string $text
 * @return string
 */
function searclink_filter ( $text )
{
	return
		preg_replace(
			array(
				"/\b(?<!')((?:itt|site|home):\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(google:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(google-(?:image|picture)s?:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(yahoo:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(yahoo-(?:image|picture)s?:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')((?:live|msn):\/\/([^<'\s]*))\b/i",
				"/\b(?<!')((?:live|msn)-(?:image|picture)s?:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(altavista:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(altavista-(?:image|picture)s?:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(alltheweb:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(alltheweb-(?:image|picture)s?:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(miner:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(tango:\/\/([^<'\s]*))\b/i",
				"/\b(?<!')(tango-(?:image|picture)s?:\/\/([^<'\s]*))\b/i",
			),
			array(
				'<a rel="search" class="search sitesearch" href="/?s=\\2">\\1</a>',
				'<a rel="search" class="search google" href="http://www.google.com/search?q=\\2">\\1</a>',
				'<a rel="search" class="search google-images search-image" href="http://images.google.com/images?q=\\2">\\1</a>',
				'<a rel="search" class="search yahoo" href="http://search.yahoo.com/search?p=\\2">\\1</a>',
				'<a rel="search" class="search yahoo-images search-image" href="http://images.search.yahoo.com/search/images?p=\\2">\\1</a>',
				'<a rel="search" class="search msn" href="http://search.live.com/results.aspx?q=\\2">\\1</a>',
				'<a rel="search" class="search msn-images search-image" href="http://search.live.com/images/results.aspx?q=\\2">\\1</a>',
				'<a rel="search" class="search altavista" href="http://www.altavista.com/web/results?q=\\2">\\1</a>',
				'<a rel="search" class="search altavista-images search-image" href="http://www.altavista.com/image/results?q=\\2">\\1</a>',
				'<a rel="search" class="search alltheweb" href="http://www.alltheweb.com/search?q=\\2">\\1</a>',
				'<a rel="search" class="search alltheweb-images search-image" href="http://www.alltheweb.com/search?cat=img&amp;q=\\2">\\1</a>',
				'<a rel="search" class="search miner-hu" href="http://miner.hu/?q=\\2">\\1</a>',
				'<a rel="search" class="search tango-hu" href="http://www.tango.hu/search.php?q=\\2">\\1</a>',
				'<a rel="search" class="search tango-hu-images" href="http://www.tango.hu/pic.php?q=\\2">\\1</a>',
			),
			$text
		);
}



add_filter('the_content', 'searclink_filter');
add_filter('the_excerpt', 'searclink_filter');
add_filter('comment_text', 'searclink_filter');

?>
