<?php
/*
Plugin Name: MIÓ (Magyar Idő Óta)
Plugin URI: http://vince.tikasz.com/mio
Description: A bejegyzések, hozzászólások dátuma/időpontja helyett a létrehozás óta eltelt időt jeleníti meg szövegesen (pl.: "tegnap reggel", "1 éve, 3 hónapja , 3 napja , 13 órája és 21 perce"). Ez a plugin a Rich Manalang <a href="http://manalang.wordpress.com/2004/05/24/wordpress-plugin-time-since/">TimeSince</a> pluginja és Phu Ly & Dunstan Orchard & Michael Heilemann <a href="http://www.ifelse.co.uk/code/timeofday.php">Time of Day</a> plugin alapján és a kódjukat felhasználva készült.
Version: 0.4
Author: Tikász Vince
Author URI: http://vince.tikasz.hu
*/

define( 'IDOOTA_RAG', 1 );
define( 'IDOOTA_TAG', 'span' );
define( 'IDOOTA_ADDITIONAL_CLASS', 'abbr' );

function time_of_day($content)
{
    //$pdate = strtotime($content);
    $pdate = strtotime(str_replace("<br />","",$content)); //WP-Admin adds a break tag for display purposes which we have to strip out.
    $hour=date('H',$pdate);
    //$hour=date('H',$content);
    switch($hour)
    {
        case 0:
        case 1:
        case 2:
            $tod = 'késő éjjel';
            break;
        case 3:
        case 4:
        case 5:
            $tod = 'hajnalban';
            break;
        case 6:
        case 7:
            $tod = 'korán reggel';
            break;
        case 8:
        case 9:
            $tod = 'reggel';
            break;
        case 10:
            $tod = 'délelőtt';
            break;
        case 11:
            $tod = 'ebéd előtt';
            break;
        case 12:
        case 13:
            $tod = 'délben';
            break;
        case 14:
            $tod = 'kora délután';
            break;
        case 15:
        case 16:
            $tod = 'délután';
            break;
        case 17:
            $tod = 'késő délután';
            break;
        case 18:
        case 19:
            $tod = 'koraeste';
            break;
        case 20:
        case 21:
            $tod = 'este';
            break;
        case 22:
            $tod = 'késő este';
            break;
        case 23:
            $tod = 'éjszaka';
            break;
        default:
            $tod = '';
            break;
    }
    return $tod;
}

function time_since($original){//, $rag=0, $notime=true)
    if ( is_admin() )
    {
        return $original;
    }
    if ( is_archive() && get_option('mio_on_archive')!=1 )
    {
        return $original;
    }
    
    global $post;

    $origTime = $post->post_date;
    $ret = '';

    // array of time period chunks
    $chunks = array
    (
        array(60 * 60 * 24 * 365 , 'év'), //0
        array(60 * 60 * 24 * 30 , 'hónap'), //1
        array(60 * 60 * 24 * 7, 'hét'),//2
        array(60 * 60 * 24 , 'nap'),//3
        array(60 * 60 , 'óra'), //4
        array(60 , 'perc'), //5
    );

    $today = time(); // Current unix time
    $orig = strtotime(str_replace("<br />","",$origTime));
    //$since = $today - strtotime($post->post_date);
    $since = $today - $orig;
    $sinceMax = get_option('mio_since_lt');
    if ($sinceMax != 0 && $since > $sinceMax ) {
        return $original;        
    }
    
    
    if (mktime(0,0,0,date('n'), date('j'), date('Y'))==mktime(0,0,0,date('n', $orig), date('j', $orig), date('Y', $orig)))
    {
        $ret = 'ma '.time_of_day($origTime);
    }
    elseif (mktime(0,0,0,date('n'), date('j')-1, date('Y'))==mktime(0,0,0,date('n', $orig), date('j', $orig), date('Y', $orig)))
    {
        $ret = 'tegnap '.time_of_day($origTime);
    }
    elseif (mktime(0,0,0,date('n'), date('j')-2, date('Y'))==mktime(0,0,0,date('n', $orig), date('j', $orig), date('Y', $orig)))
    {
        $ret = 'tegnap előtt '.time_of_day($origTime);
    }
    else
    {
        if (true == $notime) {
            $chunks = array_slice($chunks, 0, -2);
        }
        // $j saves performing the count function each time around the loop
        $_print = array();
        for ($i = 0, $j = count($chunks); $i < $j; $i++)
        {
            $seconds = $chunks[$i][0];
            $name = $chunks[$i][1];
            // finding the biggest chunk (if the chunk fits, break)
            if (($count = floor($since / $seconds)) != 0)
            {
                $since -= $count*$chunks[$i][0];
                $_print[] = $count.' '.$name;
            }
        }

        $print = join(', ', $_print);
        $print = preg_replace('/, ([^,]*$)/', ' és \\1', $print);
        if ( IDOOTA_RAG == 1 )
        {
            $print = preg_replace('/év\\b/', 'éve', $print);
            $print = preg_replace('/hónap\\b/', 'hónapja ', $print);
            $print = preg_replace('/hét\\b/', 'hete ', $print);
            $print = preg_replace('/nap\\b/', 'napja ', $print);
            $print = preg_replace('/óra\\b/', 'órája ', $print);
            $print = preg_replace('/perc\\b/', 'perce ', $print);
        }
        if ( IDOOTA_RAG == 2 )
        {
            $print = preg_replace('/év\\b/', 'évvel', $print);
            $print = preg_replace('/hónap\\b/', 'hónappal', $print);
            $print = preg_replace('/hét\\b/', 'héttel', $print);
            $print = preg_replace('/nap\\b/', 'nappal', $print);
            $print = preg_replace('/óra\\b/', 'órával', $print);
            $print = preg_replace('/perc\\b/', 'perccel', $print);
        }
        $ret = $print;
    }
    return '<'.IDOOTA_TAG.' class="'.IDOOTA_ADDITIONAL_CLASS.'" title="'.$original.'">'.$ret.'</'.IDOOTA_TAG.'>';
}

add_filter('the_time','time_since', 10);



/**
 * Cég Információk megadására szolgáló adminisztrációs panel
 */
function mio_options_page() {
    
    $chunk = array(
        array(0,                    'mindig'),
        array(60 * 60 * 24 ,        '1 nap'),
        array(60 * 60 * 24 * 2,     '2 nap'),
        array(60 * 60 * 24 * 3,     '3 nap'),
        array(60 * 60 * 24 * 7,     '1 hét'),
        array(60 * 60 * 24 * 14,    '2 hét'),
        array(60 * 60 * 24 * 30,    '30 nap (1 hónap)'),
        array(60 * 60 * 24 * 60,    '60 nap (2 hónap)'),
        array(60 * 60 * 24 * 90,    '90 nap (3 hónap)'),
        array(60 * 60 * 24 * 180,   '180 nap (fél év)'),
        array(60 * 60 * 24 * 365,   '1 év'),
        array(60 * 60 * 24 * 730,   '2 év'),
    );
?>
<div class="wrap">
<h2>Magyar Idő Óta Beállítások</h2>
<?php 
    if (isset($_POST['mio_update_me']))
    {
        update_option('mio_on_archive',     $_POST['mio_on_archive'] );
        update_option('mio_since_lt',       $_POST['mio_since_lt'] );
        update_option('mio_since_lt_num',   $_POST['mio_since_lt_num'] );
        echo '<div class="updated"><p><strong>'. __('Options saved.').'</strong></p></div>';
    }
    $mio_on_archive     = get_option('mio_on_archive');
    $mio_since_lt       = get_option('mio_since_lt');
    $mio_since_lt_num   = get_option('mio_since_lt');

?>
<form name="form1" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
<p class="submit"><input type="submit" value="<?php _e('Update Options &raquo;'); ?>" name="Submit"/></p>
<fieldset class="options">
<legend>Eltelt idő mutatása </legend>
<input type="hidden" name="mio_update_me" value="1" />
<p>
<label for="mio_on_archive">az archívumban is:</label>
<input type="checkbox" name="mio_on_archive" id="mio_on_archive" value="1" <?php if ( 1 == $mio_on_archive) { echo 'checked="checked" ';} ?> />
</p>

<p>
<label for="mio_since_lt">ahol az eltelt idő kissebb mint</label>
<select name="mio_since_lt" id="mio_since_lt">
<?php
    $default_selected_since = false;
    foreach ( $chunk as $c ) {
        $selected_since = '';
        if ( $mio_since_lt == $c[0] ) {
            $selected_since = 'selected="selected" ';
            $default_selected_since = true;
        }
        echo '<option value="'.$c[0].'"'.$selected_since.'>'.$c[1].'</option>';
    }
?>
</select>
</p>

</fieldset>
<p class="submit"><input type="submit" value="<?php _e('Update Options &raquo;'); ?>" name="Submit"/></p>
</form>
</div>
<?php
}

function mio_add_admin_pages() {
    add_options_page('MIÓ', 'Magyar Idő Óta', 8, 'mio', 'mio_options_page');
}
add_action('admin_menu', 'mio_add_admin_pages');
?>
