<?php
/*
Plugin Name: mio (Magyar Idő Óta)
Plugin URI: http://vince.tikasz.com/mio
Description: A bejegyzések, hozzászólások dátuma/időpontja helyett a létrehozás óta eltelt időt jeleníti meg szövegesen (pl.: "tegnap reggel", "1 éve, 3 hónapja , 3 napja , 13 órája és 21 perce"). Ez a plugin a Rich Manalang <a href="http://manalang.wordpress.com/2004/05/24/wordpress-plugin-time-since/">TimeSince</a> pluginja és Phu Ly & Dunstan Orchard & Michael Heilemann <a href="http://www.ifelse.co.uk/code/timeofday.php">Time of Day</a> plugin alapján és a kódjukat felhasználva készült.
Version: 0.3
Author: Tikász Vince
Author URI: http://vince.tikasz.hu
*/

define( 'IDOOTA_RAG', 1 );
define( 'IDOOTA_TAG', 'span' );
define( 'IDOOTA_ADDITIONAL_CLASS', 'abbr' );

function time_of_day($content)
{
    //$pdate = strtotime($content);
    $pdate = strtotime(str_replace("<br />","",$content)); //WP-Admin adds a break tag for display purposes which we have to strip out.
    $hour=date('H',$pdate);
    //$hour=date('H',$content);
    switch($hour)
    {
        case 0:
        case 1:
        case 2:
            $tod = 'késő éjjel';
            break;
        case 3:
        case 4:
        case 5:
            $tod = 'hajnalban';
            break;
        case 6:
        case 7:
            $tod = 'korán reggel';
            break;
        case 8:
        case 9:
            $tod = 'reggel';
            break;
        case 10:
            $tod = 'délelőtt';
            break;
        case 11:
            $tod = 'ebéd előtt';
            break;
        case 12:
        case 13:
            $tod = 'délben';
            break;
        case 14:
            $tod = 'kora délután';
            break;
        case 15:
        case 16:
            $tod = 'délután';
            break;
        case 17:
            $tod = 'késő délután';
            break;
        case 18:
        case 19:
            $tod = 'koraeste';
            break;
        case 20:
        case 21:
            $tod = 'este';
            break;
        case 22:
            $tod = 'késő este';
            break;
        case 23:
            $tod = 'éjszaka';
            break;
        default:
            $tod = '';
            break;
    }
    return $tod;
}

function time_since($original){//, $rag=0, $notime=true) {
    global $post;

    $origTime = $post->post_date;
    $ret = '';

    // array of time period chunks
    $chunks = array
    (
        array(60 * 60 * 24 * 365 , 'év'), //0
        array(60 * 60 * 24 * 30 , 'hónap'), //1
        array(60 * 60 * 24 * 7, 'hét'),//2
        array(60 * 60 * 24 , 'nap'),//3
        array(60 * 60 , 'óra'),
        array(60 , 'perc'),
    );

    $today = time(); // Current unix time
    $orig = strtotime(str_replace("<br />","",$origTime));
    //$since = $today - strtotime($post->post_date);
    if (mktime(0,0,0,date('n'), date('j'), date('Y'))==mktime(0,0,0,date('n', $orig), date('j', $orig), date('Y', $orig)))
    {
        $ret = 'ma '.time_of_day($origTime);
    }
    elseif (mktime(0,0,0,date('n'), date('j')-1, date('Y'))==mktime(0,0,0,date('n', $orig), date('j', $orig), date('Y', $orig)))
    {
        $ret = 'tegnap '.time_of_day($origTime);
    }
    elseif (mktime(0,0,0,date('n'), date('j')-2, date('Y'))==mktime(0,0,0,date('n', $orig), date('j', $orig), date('Y', $orig)))
    {
        $ret = 'tegnap előtt '.time_of_day($origTime);
    }
    else
    {
        $since = $today - $orig;
        if (true == $notime) {
            $chunks = array_slice($chunks, 0, -2);
        }
        // $j saves performing the count function each time around the loop
        $_print = array();
        for ($i = 0, $j = count($chunks); $i < $j; $i++)
        {
            $seconds = $chunks[$i][0];
            $name = $chunks[$i][1];
            // finding the biggest chunk (if the chunk fits, break)
            if (($count = floor($since / $seconds)) != 0)
            {
                $since -= $count*$chunks[$i][0];
                $_print[] = $count.' '.$name;
            }
        }

        $print = join(', ', $_print);
        $print = preg_replace('/, ([^,]*$)/', ' és \\1', $print);
        if ( IDOOTA_RAG == 1 )
        {
            $print = preg_replace('/év\\b/', 'éve', $print);
            $print = preg_replace('/hónap\\b/', 'hónapja ', $print);
            $print = preg_replace('/hét\\b/', 'hete ', $print);
            $print = preg_replace('/nap\\b/', 'napja ', $print);
            $print = preg_replace('/óra\\b/', 'órája ', $print);
            $print = preg_replace('/perc\\b/', 'perce ', $print);
        }
        if ( IDOOTA_RAG == 2 )
        {
            $print = preg_replace('/év\\b/', 'évvel', $print);
            $print = preg_replace('/hónap\\b/', 'hónappal', $print);
            $print = preg_replace('/hét\\b/', 'héttel', $print);
            $print = preg_replace('/nap\\b/', 'nappal', $print);
            $print = preg_replace('/óra\\b/', 'órával', $print);
            $print = preg_replace('/perc\\b/', 'perccel', $print);
        }
        $ret = $print;
    }
    return '<'.IDOOTA_TAG.' class="'.IDOOTA_ADDITIONAL_CLASS.'" title="'.$original.'">'.$ret.'</'.IDOOTA_TAG.'>';
}

add_filter('the_time','time_since', 10);

?>