<?php
/*
Plugin Name: WHAT Corrector
Version: 0.7.2
Plugin URI: http://tiku.extra.hu/what_for_wp/
Description: WHAT Corrector for WP based on idea of WHAT Corrector from Weblabor.hu
Author: Tikász, Vince
Author URI: http://tiku.extra.hu
*/

$WHAT_rand = get_option('WHAT_rand'); 
$mask = get_option('WHAT_mask');
$WHAT_rand_options = get_option('WHAT_rand_options');
if($WHAT_rand=='Y'){
    $len = rand($WHAT_rand_options['min'], $WHAT_rand_options['max']);
    $c = $WHAT_rand_options['c'];//'aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ0123456789';
    $mask = '';
    srand((float) microtime() * 10000000);
    for($i=0; $i<$len; $i++) {
        $mask .= $c[rand(0, strlen($c)-1)];
    }
}
if(strlen($mask)==0) {
	$mask = 'vitaminC'; 
}

function WHAT_mgr_admin_menu()
{
    add_options_page(__('WHAT Options', 'what'), __('WHAT', 'what'), 5, basename(__FILE__), 'WHAT_mgr_options_page');
}

function WHAT_mgr_options_page(){
	load_plugin_textdomain('what', 'wp-content/plugins/what/lang/');
    $update = false;
    if (isset($_POST['WHAT_update']))
    {
        update_option('WHAT_mask', $_POST['WHAT_mask'] );
        update_option('WHAT_rand', $_POST['WHAT_rand'] );
        update_option('WHAT_rand_options', array(
        'min' => $_POST['WHAT_rand_min'],
        'max' => $_POST['WHAT_rand_max'],
        'c' => $_POST['WHAT_rand_c']
    ));
        $update = true;
    }
    $mask = get_option('WHAT_mask');
    $WHAT_rand = get_option('WHAT_rand');
    $WHAT_rand_options = get_option('WHAT_rand_options');
    if ($update)
    {
    ?>
        <div class="updated"><strong><?php _e('Options saved.'); ?></strong></div>
    <?php
    }
    ?>
    <div class="wrap">
        <h2><?php _e('WHAT Options', 'what');?></h2>
        <form name="form1" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
            <fieldset>
                <legend><?php _e('WHAT Mask Options', 'what'); ?></legend>
                <input type="hidden" name="WHAT_update" value="1" />
                <ul>
                    <li><label for="mask"><?php _e('Mask String', 'what'); ?>:</label>
                    <input name="WHAT_mask" id="mask" type="text" value="<?php echo $mask; ?>" /></li>

                    <li>
                        <label for="rand"><?php _e('Generate random mask for every pageload?', 'what'); ?></label>
                        <input name="WHAT_rand" id="rand" type="checkbox" value="Y" <?php if ($WHAT_rand=="Y") echo 'checked="checked"'; ?> />
                    </li>
                </ul>
            </fieldset>
            <fieldset>
                <legend><?php _e('Random Options', 'what'); ?></legend>
                <ul>
                    <li>
                    	<?php _e('Generated Mask string length:','what'); ?>
                    	<ul>
                    		<li>
                        		<label for="WHAT_rand_min"><?php _e('Minimum','what'); ?></label>
                        		<input id="WHAT_rand_min" name="WHAT_rand_min" value="<?php echo $WHAT_rand_options['min']; ?>" size="3" />
                    		</li>
                    		<li>
                        		<label for="WHAT_rand_max"><?php _e('Maximum','what'); ?></label>
                        		<input id="WHAT_rand_max" name="WHAT_rand_max" value="<?php echo $WHAT_rand_options['max']; ?>" size="3" />
                    		</li>
                    	</ul>
                    </li>
                    <li>
                        <label for="WHAT_rand_c"><?php _e('Characters','what'); ?></label>
                        <input id="WHAT_rand_c" name="WHAT_rand_c" value="<?php echo $WHAT_rand_options['c']; ?>" size="60"/>
                    </li>
                </ul>
            </fieldset>
            <input type="submit" value="<?php _e('Save Changes &raquo;'); ?>">
        </form>
    </div>
    <?php
}

function ob_starter () {
    if (!is_admin()) {
        ob_start('masking');
    }
}

function masking ($content) {
    if(!preg_match('/<\/head>/', $content)) {
      return $content;
    }
    global $mask;
    $content = preg_replace("/@/", "#:#{$mask}#:#", $content);
    $h = spliti('</head>', $content);
   	$head = preg_replace("/(?<!x=\/)#:#{$mask}#:#(?!\/gi)/", '@', $h[0]);
    return $head.'</head>'.$h[1];
}

function WHAT_add_options()
{
    add_option('WHAT_rand', 'Y');
    add_option('WHAT_mask', 'vitaminB');
    add_option('WHAT_rand_options', array(
        'min' => 3,
        'max' => 9,
        'c' => 'aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTuUvVwWxXyYzZ0123456789'  
    ));
}

WHAT_add_options();

function add_what () {
	echo '<script type="text/javascript"><!--
function w(){var x=/@/gi;var y=document.getElementsByTagName("textarea");var z=y.length;var t=new Array(z);for(var i=0;i<z;i++){t[i]=y[i].value;}document.body.innerHTML=document.body.innerHTML.replace(x,String.fromCharCode(64));for(var i=0;i<z;i++){y[i].value=t[i];}};if(window.addEventListener){window.addEventListener("load", w, true);}else if(window.attachEvent){window.attachEvent("onload",w);}
--></script>';
}

add_action('wp_head', 'add_what');
add_action('init', 'ob_starter');
add_action('admin_menu', 'WHAT_mgr_admin_menu');
?>